;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "reader.ss" "plai" "lang")
;; La GC es similar al WAE, agregando unicamente las reglas:
;; WAE ::= {with WAE WAE}
;; WAE ::= < number >
(define-type WAE 
  [num (n number?)] 
  [add (lhs WAE?) (rhs WAE?)] 
  [sub (lhs WAE?) (rhs WAE?)] 
  [with (name symbol?) (named-expr WAE?) (body WAE?)] 
  [id (name symbol?)]
  [dwith (named-expr WAE?) (body WAE?)] ;; agregado para usar {with 5 <0>}
  [in (index number?)])                 ;; agregado por usar <0> 

;; parse: List -> WAE(AST)
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(symbol? sexp) (id sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(-) (sub (parse(second sexp))
                 (parse(third sexp)))]
       [(with) (with (first (second sexp))
                     (parse (second (second sexp)))
                     (parse (third sexp)))]
       )
     ]
    ))

;; subst : WAE x symbol x number → WAE 
;; Idéntica a la función de substitución explícita, lo único que cambia
;; son dos l'inas (triviales) al final de la funci'on
(define (subst expr sub-id val) 
  (type-case WAE expr 
             [add (l r) (add (subst l sub-id val) 
                             (subst r sub-id val))] 
             [sub (l r) (sub (subst l sub-id val) 
                             (subst r sub-id val))] 
             [with (bound-id named-expr bound-body) 
                   (if (symbol=? bound-id sub-id) 
                       (with bound-id 
                             (subst named-expr sub-id val) 
                             bound-body) 
                       (with bound-id 
                             (subst named-expr sub-id val) 
                             (subst bound-body sub-id (+ 1 val))))] ;; 1er modif.
             [id (v) (if (symbol=? v sub-id) (in val) expr)]        ;; 2da modif. 
             [else expr])) 

;; toDeBruijn : WAE → WAE
;; Transforma la expresi'on, eliminando los with cl'asico por los with con
;; 'indice De Bruijn
(define (toDeBruijn expr) 
  (type-case WAE expr
             [add (l r) (add (toDeBruijn l) (toDeBruijn r))] 
             [sub (l r) (sub (toDeBruijn l) (toDeBruijn r))] 
             [with (bound-id named-expr bound-body) 
                   (dwith named-expr
                          (toDeBruijn (subst bound-body 
                                             bound-id 
                                             0)))] 
             [id (v) (error 'free-identifier)]
             [else expr])) 



(test (toDeBruijn (parse '{with {x 3} {+ x 5}})) 
      (dwith (num 3) 
             (add (in 0) (num 5))))

(test (toDeBruijn (parse 
'{with {x 5}
  {with {y {+ x 2}}
    {+ x 
       {with {y {- y 1}}
         {+ y x}}}}}))
(dwith (num 5) 
       (dwith (add (in 0) (num 2)) 
              (add (in 1) 
                   (dwith (sub (in 0) (num 1)) 
                          (add (in 0) (in 2)))))))